(function($) {
    $.fn.eak_accordion = function(options) {
        return this.each(function() {
            var $el = jQuery(this),
                $accordions = $el.find('.eak_accordion__group'),
                multiple_allowed = ($el.attr('data-eak_accordion--multiple') == "1") ? true : false,
                icon_active = $el.attr('data-eak_accordion--icon_active'),
                icon_inactive = $el.attr('data-eak_accordion--icon_inactive');

            toggle_accordion = function($accordion) {
                $accordion.find('.eak_accordion__body').stop().slideToggle(200, function() {
                    $accordion.toggleClass('active');
                    $accordion.find('.eak_accordion__title').toggleClass('active');
                    $accordion.find('.eak_accordion__icon > i').toggleClass(icon_active).toggleClass(icon_inactive);
                });
            };

            $accordions.find('.eak_accordion__title').click(function(e) {
                e.preventDefault();
                // close others
                var $old_active = $el.find('.eak_accordion__group.active'),
                    close = false;

                if (jQuery(this).hasClass('active')) {
                    close = true;
                }
                console.log(multiple_allowed);
                if (!multiple_allowed) {
                    $old_active.find('.eak_accordion__body').stop().slideUp(200, function() {
                        jQuery(this).parent().removeClass('active');
                        jQuery(this).parent().find('.eak_accordion__title').removeClass('active');
                        jQuery(this).parent().find('.eak_accordion__icon > .fa').removeClass(icon_active).addClass(icon_inactive);
                    });
                }

                toggle_accordion(jQuery(this).parent());
            });
        });
    };
}(jQuery));